<?php

namespace app\controllers;

use app\models\Employee;
use app\models\EmployeeSearch;
use app\models\EmployeeInfo;
use app\models\ClientMaster;
use app\models\TableMaster;
use app\models\RequestMasterSearch;
use app\models\ClientMasterSearch;
use app\models\TableMasterSearch;
use app\models\EmployeeRole;
use app\models\RequestMaster;
use app\models\PrivilegeMaster;
use app\models\InstanceMaster;
use app\models\RoleMaster;
use app\models\AccessMaster;
use app\models\RequestTypeMaster;
use app\models\RequestServiceMaster;
use yii\data\ActiveDataProvider;
use app\models\RequestLog;
use Yii;
use yii\web\Session;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;



/**
 * AdminController implements the CRUD actions for Employee model.
 */

class AdminController extends Controller
{

    CONST access_error = "You are not allowed to access admin's page";
    CONST same_user = "You are not allowed to handle your own request";
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    public function actionIndex()
    {
        if(in_array(AccessMaster::VIEW_REQUEST,Yii::$app->session->get('actions')))
        {
            $searchModel = new RequestMasterSearch();
            $dataProvider = $searchModel->search($this->request->queryParams);

            return $this->render('index', [
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,

            ]);
        }
        else
        {
            Yii::$app->session->setFlash('error',self::access_error);
            return $this->redirect(['request-master/index']);
        }
    }

    public function actionRequestDetail($id = NUll)
    {
        if(Yii::$app->session->has('actions'))
        {
          $model = RequestMaster::getCurrentRequestLogDetail($id);
          $requestLog = new RequestLog();
          return $this->render('requestDetail',['model' => $model,'requestLog' => $requestLog,]);
        }
        else
        {
            return $this->redirect(['site/index']);
        }
    }

    public function actionEmployeeDetails()
    {
        if(in_array(AccessMaster::LIST_EMPLOYEE,Yii::$app->session->get('actions')))
        {
            $searchModel = new EmployeeSearch();
            $dataProvider = $searchModel->search($this->request->queryParams);
            return $this->render('employee/employeeList', [
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }
        else
        {
            Yii::$app->session->setFlash('error',self::access_error);
            return $this->redirect(['request-master/index']);
        }
    }

    public function actionView($id)
    {
        $data = $this->findModel($id);
        return $this->render('employee/view', [
            'model' => $data['model'],
        ]);
    }


    public function actionCreate()
    {
        $model = new Employee();
        $modelInfo = new EmployeeInfo();
        $employeeMap = new EmployeeRole();

        $transaction = \Yii::$app->db->beginTransaction();

        if (\Yii::$app->request->post())
        {
            $employee = \Yii::$app->request->post('Employee');
            $employeeInfo = \Yii::$app->request->post('EmployeeInfo');
            $employeeRoles = \Yii::$app->request->post('EmployeeRole');
            $model->created_at = date('Y-m-d h:i:s');
            $model->password = sha1($employeeInfo['access_username']);
            $model->attributes = $employee;
            $model->is_active = 1;
            try
            {
                if($model->save())
                {
                    $employeeInfo['effective_date'] = \Yii::$app->formatter->asDate($employeeInfo['effective_date'], "yyyy-MM-dd");
                    $employeeInfo['end_date'] = !empty($employeeInfo['end_date']) ? \Yii::$app->formatter->asDate($employeeInfo['effective_date'], "yyyy-MM-dd")  : null;
                    $modelInfo->attributes = $employeeInfo;
                    $modelInfo->employee_id = $model->id;

                    if($modelInfo->validate())
                    {
                        $modelInfo->save(false);
                        foreach($employeeRoles['role_id'] as $role)
                        {
                            $employeeMap = new EmployeeRole();
                            $employeeMap->employee_id = $model->id;
                            $employeeMap->role_id = $role;
                            $employeeMap->save();
                        }

                        $transaction->commit();
                        return $this->redirect(['view', 'id' => $model->id]);
                    }
                }

            } catch (Exception $e) {

                $transaction->rollBack();
                throw $e;
            }
        }

        return $this->render('employee/create', [
                    'model' => $model,
                    'modelInfo' => $modelInfo,
                    'employeeMap' => $employeeMap,
        ]);
    }


    public function actionUpdate($id)
    {
        // Update employee
        $transaction = \Yii::$app->db->beginTransaction();
        $data = $this->findModel($id);
        $employeeMap = EmployeeRole::find()->where('employee_id = :employee_id', array(':employee_id' => $id))->all();
//        echo'<pre>'; print_R($employeeMap); exit;
        $model = $data['model'];                  //The returned model array stored as "$model & $modelInfo" & used here by spliting  array key.
        $modelInfo = $data['modelInfo'];
        if($this->request->isPost)
        {
            $employee = \Yii::$app->request->post('Employee');         //Post data stored in "employee & employeeInfo"
            $employeeInfo = \Yii::$app->request->post('EmployeeInfo');
            $employeeRoles = \Yii::$app->request->post('EmployeeRole');
            try {
                  $model->attributes = $employee;
                  $model->is_active = 1;
                if($model->validate())
                   {
                      $model->save(false);
                      $employeeInfo['effective_date'] = \Yii::$app->formatter->asDate($employeeInfo['effective_date'], "yyyy-MM-dd");  //Date format is changed uding formatter & stored in table
                      $employeeInfo['end_date'] = !empty($employeeInfo['end_date']) ? \Yii::$app->formatter->asDate($employeeInfo['effective_date'], "yyyy-MM-dd")  : null; // For end-date if condtion used , end date will be null if not selected.
                      $modelInfo->attributes = $employeeInfo;
                      if($modelInfo->validate())
                      {
                        $modelInfo->save(false);
                        foreach ($employeeMap as $employeeRole)
                        {
                            $employeeRole->delete();
                        }
                        foreach($employeeRoles['role_id'] as $role)
                         {
                            $employeeMap = new EmployeeRole();
                            $employeeMap->employee_id = $model->id;
                            $employeeMap->role_id = $role;
                            $employeeMap->save();
                         }

                         $transaction->commit();
                         return $this->redirect(['view', 'id' => $model->id]);
                      }
                   }

                }
                catch (Exception $e)
                {
                        $transaction->rollBack();
                        throw $e;
                }
        }
        return $this->render('employee/update', [
                    'model' => $model,
                    'modelInfo' => $modelInfo,
                    'employeeMap' => $employeeMap,
        ]);
    }


    public function actionDelete($id)
    {
        //Using Id deleting the employee & their details
        $data = $this->findModel($id);
        $model = $data['model'];
        $modelInfo = $data['modelInfo'];
        $employeeMap = EmployeeRole::find()->where('employee_id = :employee_id', array(':employee_id' => $id))->one();
        $model->is_active = 0;
        $model->save(false);
        return $this->redirect(['employee-details']);
    }

    protected function findModel($id)
    {
        if (($model = Employee::find()->where('id = :id', array(':id' => $id))->one()) !== null  && ($modelInfo = EmployeeInfo::find()->where('employee_id = :employee_id', array(':employee_id' => $id))->one()) !== null)
        {
            $data['model'] = $model;
            $data['modelInfo'] = $modelInfo;
            return $data;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionListOfForms()
    {
        return $this->render('formsList');

    }

    public function actionClientView()
    {
        if(in_array(AccessMaster::VIEW_CLIENT,Yii::$app->session->get('actions')))
        {
            $searchModel = new ClientMasterSearch();
            $dataProvider = $searchModel->search($this->request->queryParams);

            return $this->render('client/view',[
                'dataProvider' => $dataProvider,]
             );
        }
        else
        {   Yii::$app->session->setFlash('error',self::access_error);
            return $this->redirect(['request-master/index']);
        }
    }

    public function actionClientCreate()
    {
        //Admin can add new client
        if(in_array(AccessMaster::CREATE_CLIENT,Yii::$app->session->get('actions')))
        {
            $transaction = \Yii::$app->db->beginTransaction();
            $modelClient = new ClientMaster();
            if($this->request->isPost)
            {
                $client =  \Yii::$app->request->post('ClientMaster');
                $modelClient->attributes = $client;
                try
                {
                    if($modelClient->validate())
                    {
                        $modelClient->save(false);
                        $transaction->commit();
                        return $this->redirect(['index']);
                    }
                }
                catch (Exception $ex)
                {
                    $transaction->rollBack();
                    throw $ex;
                }
            }
            return $this->render('client/create', [
                    'modelClient' => $modelClient,
            ]);
        }
        else
        {
            Yii::$app->session->setFlash('error',self::access_error);
            return $this->redirect(['request-master/index']);
        }
    }

    public function actionClientUpdate($id)
    {
        //Admin can update client in db
        if(in_array(AccessMaster::UPDATE_CLIENT,Yii::$app->session->get('actions')))
        {
            $transaction = \Yii::$app->db->beginTransaction();
            $modelClient = ClientMaster::find()->where('id = :id', array(':id' => $id))->one();
            if($this->request->isPost)
            {
                $client =  \Yii::$app->request->post('ClientMaster');
                $modelClient->attributes = $client;

                try
                {
                    if($modelClient->validate())
                    {
                        $modelClient->save(false);
                        $transaction->commit();
                        return $this->redirect(['client-view']);
                    }
                }
                catch (Exception $ex)
                {
                    $transaction->rollBack();
                    throw $ex;
                }
            }

        return $this->render('client/update', [
                    'modelClient' => $modelClient,
        ]);
        }
        else
        {
            Yii::$app->session->setFlash('error',self::access_error);
            return $this->redirect(['request-master/index']);
        }
    }

    public function actionTableView()
    {
        if(in_array(AccessMaster::VIEW_TABLE,Yii::$app->session->get('actions')))
        {
            $dataProvider = new ActiveDataProvider([
                'query' => TableMasterSearch::find(),
                'pagination' => [
                    'pageSize' => 15,
                ],
            ]);
            return $this->render('table/view',[
                    'dataProvider' => $dataProvider,
                ]
            );
        }
        else
        {   Yii::$app->session->setFlash('error',self::access_error);
            return $this->redirect(['request-master/index']);
        }
    }

    public function actionTableCreate()
    {
        //Admin can add new tables in db
        if(in_array(AccessMaster::CREATE_TABLE,Yii::$app->session->get('actions')))
        {
            $transaction = \Yii::$app->db->beginTransaction();
            $modelTable = new TableMaster();
            if($this->request->isPost)
            {
                $table =  \Yii::$app->request->post('TableMaster');
                $modelTable->attributes = $table;

                try
                {
                    if($modelTable->validate())
                    {
                        $modelTable->save(false);
                        $transaction->commit();
                        return $this->redirect(['index']);
                    }
                }
                catch (Exception $ex)
                {
                    $transaction->rollBack();
                    throw $ex;
                }
            }

        return $this->render('table/create', [
                    'modelTable' => $modelTable,
        ]);
        }
        else
        {
            Yii::$app->session->setFlash('error',self::access_error);
            return $this->redirect(['request-master/index']);
        }
    }

    public function actionTableUpdate($id)
    {
        //Admin can update tables in db
        if(in_array(AccessMaster::UPDATE_TABLE,Yii::$app->session->get('actions')))
        {
            $transaction = \Yii::$app->db->beginTransaction();
            $modelTable = TableMaster::find()->where('id = :id', array(':id' => $id))->one();
            if($this->request->isPost)
            {
                $table =  \Yii::$app->request->post('TableMaster');
                $modelTable->attributes = $table;

                try
                {
                    if($modelTable->validate())
                    {
                        $modelTable->save(false);
                        $transaction->commit();
                        return $this->redirect(['table-view']);
                    }
                }
                catch (Exception $ex)
                {
                    $transaction->rollBack();
                    throw $ex;
                }
            }

            return $this->render('table/update', [
                    'modelTable' => $modelTable,
            ]);
        }
        else
        {
            Yii::$app->session->setFlash('error',self::access_error);
            return $this->redirect(['request-master/index']);
        }
    }

    public function actionMaster()
    {
        if(in_array(AccessMaster::VIEW_MASTER, Yii::$app->session->get('actions')))
        {
            $dataProvider1 = new ActiveDataProvider([
                'query' => RequestTypeMaster::find(),
                'pagination' => [
                    'pageSize' => 10,
                ],
            ]);
            $dataProvider2 = new ActiveDataProvider([
                'query' => InstanceMaster::find(),
                'pagination' => [
                    'pageSize' => 10,
                ],
            ]);
            $dataProvider3 = new ActiveDataProvider([
                'query' => RequestServiceMaster::find(),
                'pagination' => [
                    'pageSize' => 10,
                ],
            ]);
            $dataProvider4 = new ActiveDataProvider([
                'query' => PrivilegeMaster::find(),
                'pagination' => [
                    'pageSize' => 10,
                ],
            ]);
            return $this->render('master', [
                    'dataProvider1' => $dataProvider1,
                    'dataProvider2' => $dataProvider2,
                    'dataProvider3' => $dataProvider3,
                    'dataProvider4' => $dataProvider4,
            ]);
        }
        else
        {
            Yii::$app->session->setFlash('error',self::access_error);
            return $this->redirect(['request-master/index']);
        }
    }

    public function actionRequestStatus($id,$flag,$message=NULL)
    {

        $model = RequestMaster::getCurrentRequestLogDetail($id);
        $requestMastermodel = RequestMaster::find()->where(['id'=>$id])->one();
        $requestLog = new RequestLog();
        $valid = $this->actionRequestPermission($model->request->employee_id);
        $client_name = empty($model->request->client->name) ? 'Qbrik' : $model->request->client->name;
        $instance_name = empty($model->request->instance->name) ? '' : $model->request->instance->name;
        if($valid)
        {
            if($flag == RequestMaster::approve)
            {
                $requestMastermodel->status_id = RequestMaster::approve;
                $requestLog->status_id = RequestMaster::approve;
                $mailSubject = Employee::project_name . ' - ' . 'The' . $model->request->requestService->name . ' request on ' . $client_name . ' has been approved.';
                $mailbody = 'Your request #' . $model->request->id . ' for ' . $model->request->requestService->name . ' on ' . $client_name . ' has been approved by ' . Yii::$app->user->identity->name . ' on '. date('Y-m-d H:i:s') . '.' .'You will receive final confirmation mail once request is granted.';
            }
            else if($flag == RequestMaster::decline)
            {
                $requestMastermodel->status_id = RequestMaster::decline;
                $requestLog->status_id = RequestMaster::decline;
                $requestLog->message = $message;
                $mailSubject = Employee::project_name . ' - ' . 'The' . $model->request->requestService->name . ' request on ' . $client_name . ' has been decline.';
                $mailbody = 'Your request #' . $model->request->id . ' for ' . $model->request->requestService->name . ' on ' . $client_name . ' has been declined by ' . Yii::$app->user->identity->name . ' on '. date('Y-m-d H:i:s') . '.' . PHP_EOL . 'Due to following reason : ' .   $requestLog->message . PHP_EOL .'Please initiate a request again with required/correct details .';
            }
            else
            {
                $requestMastermodel->status_id = RequestMaster::revoke;
                $requestLog->status_id = RequestMaster::revoke;
                $instance = !empty($model->request->instance->name) ? $model->request->instance->name : '';
                $mailSubject = Employee::project_name . ' - ' . 'The ' . $model->request->requestService->name . ' request on ' . $client_name . ' has been revoked.';
                $mailbody = 'The request #' . $model->request->id . $model->request->requestService->name . ' access for user ' . $requestMastermodel->employee->employeeInfos[0]->access_username . ' on ' . $client_name . ' ' . $instance . ' instance has been revoked by ' . Yii::$app->user->identity->name . ' on ' . date('Y-m-d H:i:s');
            }

            $requestLog->request_id = $model->request->id;
            $requestLog->file_path = $model->file_path;
            $requestLog->user_id = Yii::$app->user->identity->id;
            $requestLog->posting_time = date('Y-m-d G:i:s');

            $requestMastermodel->save(false);
            $requestLog->save(false);

            $mailFrom = RoleMaster::admin_mail;
            $mailTo = $requestMastermodel->employee->email;/* Testing */
            $mail_cc = RoleMaster::admin_cc_for_status;
            $this->sendMail($mailFrom, $mailTo,$mail_cc,$mailSubject,$mailbody);
            Yii::$app->session->setFlash('success','Mail sent successfully to ' . $model->request->employee->name);
            //$this->redirect(['index']);
	    $this->redirect(['request-detail', 'id' => $id]);
        }
        else
        {
            Yii::$app->session->setFlash('error',self::same_user);
            return $this->render('requestDetail',['model' => $model,'requestLog' => $requestLog]);
        }
    }

    public function actionDeclineMessage($id)
    {
        $request_log_model = new RequestLog();
        if(\Yii::$app->request->post())
        {
            $message = $_POST['RequestLog']['message'];
            return $this->redirect(['request-status','id' => $id ,'flag' => RequestMaster::decline,'message' => $message ]);
        }

        return $this->render('declineReason',['request_log_model' => $request_log_model]);
    }

    public function actionRequestPermission($id)
    {
        $loginmail = Yii::$app->user->identity->email;
        $employeeModel = Employee::findEmployee($id);
        $requestmail = $employeeModel['email'];
        if($loginmail == $requestmail)
        {
            return false;
        }
        else
        {
            return true;
        }
    }

    public function sendMail($mailFrom,$mailTo,$mail_cc,$mailSubject,$mailBody)
    {
        $mail = \Yii::$app->mailer->compose();

              $mail->setFrom($mailFrom);
              $mail->setTo($mailTo);
              $mail->setCc($mail_cc);
              $mail->setSubject($mailSubject);
              $mail->setTextBody($mailBody);
              $mail->send();
    }

    public function actionResetPassword($id)
    {
        $model = Employee::findEmployee($id);
        $error = '';
        if(\Yii::$app->request->post())
        {
	   $password = $_POST['Employee']['password'];
           $confirm_password = $_POST['confirm-password'];
           $valid = !empty($password) && !empty($confirm_password) ? true : false;
           if($valid)
           {
               $valid1 = (preg_match('/^(?=.*\d)(?=.*[A-Za-z])[0-9A-Za-z!_.:;@#$%]{8,}$/', $password)) ? true :  $model->addError('*', 'Password not in given pattern');
//            var_dump($valid1); exit;
               $valid2 = (\strcmp($password,$confirm_password) === 0) ? true : $model->addError('*', 'Password & Confirm password are not same');
//var_dump($valid2); exit;
               if($valid1 && $valid2)
               {
                    $model->password = sha1($password);
                    $model->last_login = NULL;
                    $model->save(false);
                    return $this->redirect(['view','id' => $model->id]);
               }
           }
           else
           {
               $model->addError('*','Password Cannot be blank');
           }
	}
	return $this->render('employee/_reset',['model'=>$model,'error' => $error]);
    }

    public function actionFileDownload($Filepath)
    {
        return Yii::$app->response->sendFile($Filepath)->send();
    }
}
