<?php

namespace app\controllers;

use yii\authclient\OAuth2;
use app\components\AuthHandler;
use yii\authclient\BaseClient;
use idk\yii2\google\apiclient;
use Composer\Autoload;
use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use app\models\UserForm;

class LoginController extends Controller
{

    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['index', 'login', 'logout'],
                'rules' => [
                    [
                        'allow' => true,
                        'actions' => ['login', 'signup', 'auth'],
                        'roles' => ['?'],
                    ],
                    [
                        'allow' => true,
                        'actions' => ['index', 'logout'],
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    public function beforeAction($action) 
    { 
        $this->enableCsrfValidation = false; 
        return parent::beforeAction($action); 
    }
    public function actions()
    {
        return [
            'auth' => [
                'class' => 'yii\authclient\AuthAction',
                'successCallback' => [$this, 'successCallback'],
            ],
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    public function successCallback($client)
    {
        (new AuthHandler($client))->handle();
    }
    public function actionIndex()
    {
        return $this->render('index', []);
    }
    public function actionAbout()
    {
        return $this->render('about');
    }

    public function actionLogin()
    {
        $model = new \app\models\Employee();
        return $this->render('login', [
            'model' => $model,
        ]);
    }

    public function actionLogout()
    {
        Yii::$app->user->logout();
        return $this->redirect('/site/index');
    }

    public function actionError()
    {
        return $this->render('error', []);
    }
}