<?php

namespace app\controllers;

use Yii;
use app\models\RequestMaster;
use yii\data\ActiveDataProvider;
use app\models\RequestServiceMaster;
use app\models\RequestMasterSearch;
use app\models\RequestDetail;
use app\models\RequestLog;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use app\models\Employee;
use app\models\EmployeeInfo;
use app\models\TableMaster;
use app\models\PrivilegeMaster;
use yii\helpers\ArrayHelper;
use app\models\RequestTypeMaster;
use app\models\RoleMaster;
use \yii\web\UploadedFile;
/**
 * RequestMasterController implements the CRUD actions for RequestMaster model.
 */
class RequestMasterController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all RequestMaster models.
     *
     * @return string
     */
    public function actionIndex()
    {
        if(!empty( Yii::$app->user->identity->id))
        {
            $searchModel = new RequestMasterSearch();  /* RequestMaster::find()->where('employee_id = :employee_id', array(':employee_id' => $id))->all();*/
            $user = Employee::find()->where('id = :id', array(':id' => Yii::$app->user->identity->id))->one();
            $userId = $user->id;
            $query = RequestMaster::find()->where('employee_id = :employee_id', array(':employee_id' => $userId))->orderBy(['id' => SORT_DESC,]);
            $dataProvider = new ActiveDataProvider([
                    'query' => $query,
                    'pagination' => ['pageSize' => 10],
            ]);

            return $this->render('index', [
                'searchModel' => $searchModel,
                'dataProvider' => $dataProvider,
            ]);
        }
        else
        {
            return $this->redirect(['site/index']);
        }

    }

    public function actionView($id)
    {
        if(!empty( Yii::$app->user->identity->id))
       {
        $model = RequestMaster::getCurrentRequestLogDetail($id);
        return $this->render('view', [
            'model' => $model,
        ]);
       }else{return $this->redirect(['site/index']);}
    }



    public function actionRequest()
    {
        $flag = false;
        $modelEmployee = new Employee();
        $model = new RequestMaster();
        $modelEmployee = $modelEmployee->findEmployee();
        $username = EmployeeInfo::find()->where('employee_id = :employee_id', array(':employee_id' => $modelEmployee->id))->one();
        $modelRequest = new RequestDetail();
        $requestLog = new RequestLog();
        $transaction = \Yii::$app->db->beginTransaction();
        $selectedType = '';
        $selectedID = '';

        if ($this->request->isPost)
        {
                $employee = ArrayHelper::toArray($modelEmployee->employeeInfos);
                $mysqlaccess_user = $employee[0]['access_username'];
                $current_date = date_create(date('Y-m-d'));   /* $model for RequestMaster  all request data will be stored in the model */
                $model->employee_id = $modelEmployee->id;
                $model->posting_time = date('Y-m-d G:i:s');
                $model->status_id = RequestMaster::new;
                $model->attributes = \Yii::$app->request->post('RequestMaster');
                $selectedType = empty($model->requestService->name) ? null : $model->requestService->name;
                $selectedID = empty($model->request_service_id) ? null : $model->request_service_id;
                $type_name =  empty($model->requestType->name) ? null : $model->requestType->name;
                $requestLog->posting_time = $model->posting_time;           /* $requestLog for RequestLog  all request log & message will be stored in the model */

             $isMysql = $selectedType == RequestServiceMaster::MYSQL ? true : false;
             $isVpn = $selectedType == RequestServiceMaster::VPN || $type_name  != RequestTypeMaster::ACCESS_REQUEST ? true : false;

            //$number_of_days_valid = $_POST['radio-button'] == 1 ? false : true;
//                $number_of_days_valid = !empty($model->number_of_days) ? true : false;
		if (array_key_exists('radio-button', $_POST))
            {
                $number_of_days_valid = $_POST['radio-button'] == 1 ? false : true;
            }
            else
            {
                $number_of_days_valid = true;
            }

                if(!$isVpn)
                {
                    $model->scenario = RequestMaster::SCENARIO_ACCESS;
                }

                if($number_of_days_valid)
                {
                    $number_of_days = \Yii::$app->formatter->asDate($model->number_of_days, "yyyy-MM-dd");
                    $number_of_days = date_diff($current_date, date_create($number_of_days));
                    $model->number_of_days = $number_of_days->format('%a') + 1;
                }
                else {$model->number_of_days = null;}

                $requestLog->status_id = RequestMaster::new;
                $requestLog->user_id = $model->employee->id;
                $requestLog->posting_time = $model->posting_time;
                $file_upload = UploadedFile::getInstance($requestLog, 'file_path');
                if($file_upload)
                {
                    $writeDirPath = \Yii::$app->basePath . '/files/' . RequestLog::Upload_File . '/';
                    $file_upload->saveAs($writeDirPath.$file_upload->basename.'.'.$file_upload->extension );
                    $requestLog->file_path = $file_upload->name;
                }

                if($model->validate())
                {
                    $valid = $requestLog->validate();
                }
                else
                {
                     $valid = false;
                }

            try
                {
                    if($valid)
                    {
                        $model->save(false);
                        $requestLog->request_id = $model->id;
                        $requestLog->save(false);
                        $mailFrom = $model->employee->email;
                        $mailTo = RoleMaster::admin_mail; /*'indrajith@qbrik.in';  Testing */
                        $mail_cc = RoleMaster::admin_cc_for_request;
                        $client_name = !empty($model->client->name) ? $model->client->name : '';
                        $content = !empty($client_name) ? " for " . $client_name : '';
                        $mailSubject = Employee::project_name . ' - ' . $model->requestService->name . ' Request Initiated by ' . $username->access_username . ' ' . $content . '';
                        $flag = true;
                        $file = '';

                        if($model->request_type_id == RequestTypeMaster::accessRequest && $isMysql)
                        {
                            $mysqlFields = \Yii::$app->request->post('RequestDetail');
                            $mysql_details = $this->ValidateMysql($mysqlFields,$model);
                            if($mysql_details[0])
                            {
                                $mysql = $mysql_details[1];

                                foreach($mysql as $data)
                                {
                                   if(array_key_exists('id',$data))
                                   {
                                        $modelRequest = new RequestDetail();
                                        $modelRequest->request_id = $model->id;
                                        $modelRequest->attributes = $data;
                                        $modelRequest->save(false);
                                   }
                                }

                                $log =  RequestLog::find()->where('request_id = :id', array(':id' => $model->id))->one();
    //                                $mailSubject = Employee::project_name . ' - Mysql Privilege Request' .' - '. $model->client->name .'/'.$mysqlaccess_user;
                            $file = $model->request_service_id == RequestMaster::MYSQL ? $this->fileWriteCheck($model,$username) : NULL;

                                $log->file_path = $file;  /* empty($file) ? NULL : $file */
                                $log->save(false);
                                $flag = true;
                            }
                            else
                            {
                                $flag = false;
                                $modelRequest->addError('*','Mysql Fields Cannot be blank');
                            }
                        }
                    }

                    if($flag)
                    {
                        $transaction->commit();
                        $mailBody = 'The request #' . $model->id . ' has been initiated by ' . $username->access_username . " on " . $model->posting_time . " for " . $model->requestService->name . '.';
                        $mailBody .= ($model->requestService->name == RequestServiceMaster::MYSQL) ? PHP_EOL . "File Name : " . $file : '';
                        $link = Yii::$app->urlManager->createAbsoluteUrl(['admin/request-detail', 'id' => $model->id]);
                        $body = "<p>$mailBody</p>"
                                . "<p><a href='$link'>View Request Detail</a></p>";
                        $this->sendMail($mailFrom, $mailTo,$mail_cc, $mailSubject,$body);

                        Yii::$app->session->setFlash('success','Your Request Has been sent successfully');
                        return $this->redirect(['index']);
                    }
                }
                catch (Exception $e)
                {
                    $transaction->rollBack();
                    throw $e;
                }
            }
            else
            {
                $model->loadDefaultValues();
            }

        if(!$flag)
        {
            return $this->render('create', [
                'model' => $model,
                'modelEmployee' => $modelEmployee,
                'modelRequest' => $modelRequest,
                'requestLog' => $requestLog,
                'selectedType' => $selectedType,
                'selectedID' => $selectedID,
            ]);
        }

    }

    public function ValidateMysql($mysqlFields,$model)
    {
        $modelRequest = new RequestDetail();
        $count = 0;
        $flag_mysql = false;
        $table = $mysqlFields['table_id'];
        $privilege = $mysqlFields['privilege_id'];
        $column = $mysqlFields['column_name'];
        $modelRequest->scenario = RequestDetail::SCENARIO_MYSQL;
        $mysqlrequest=[];
        if(!empty($table) && !empty($privilege))
        {
            foreach($privilege as $data)
            {
                for($i=0; $i < count($data) ; $i++)
                {
                    $modelRequest->request_id = $model->id;
                    $modelRequest->table_id = $table[$count];

                    if(empty($data[$i]))
                    {
                        $data[$i] ='';
                    }

                    $modelRequest->privilege_id = $data[$i];

                        if($data[$i] == 2)
                        {
                            $modelRequest->column_name = $column[$count];
                        }
                        else
                        {
                            $modelRequest->column_name = NULL;
                        }
                    if($modelRequest->validate())
                    {
                       $mysqlrequest[] = $modelRequest->attributes;
                       $flag_mysql = true;
                    }
                    else
                    {
                        $mysqlrequest[] = $modelRequest->getErrors();
                    }
                }
                $count++;
            }
        }

        $mysql = [$flag_mysql,$mysqlrequest];

        if($flag_mysql)
        {
            return $mysql;
        }
        else
        {
            return $mysql;
        }


    }

    public function fileWriteCheck($model,$username)
    {
         $file_name = $model->id . '_' . $username->access_username . '.txt';
//         $file = $username->access_username .'-grant_'. date('YmdGis') . '.txt';
         $writeDirPath = \Yii::$app->basePath . '/files/' . RequestLog::Mysql_Privilege . '/';

        if (file_exists($writeDirPath))
        {
            if (!is_writable($writeDirPath))
            {
                throw new \yii\base\UserException("Directory is not writable: $writeDirPath");
            }
            else
            {
                $file = $writeDirPath . $file_name; /*$writeDirPath . */
                foreach($model->requestDetails  as $data)
                {
                   $table = TableMaster::find()->where('id = :id', array(':id' => $data->table_id))->one();
                   $privilege = PrivilegeMaster::find()->where('id = :id', array(':id' => $data->privilege_id))->one();
                   $mysql  = $data->column_name != NULL ? $privilege->name . '('. $data->column_name .')'.'|'. $table->name  : $privilege->name .'|'. $table->name;
                   $contents[] = $username->access_username.'|'.  $mysql  .'|'. $model->employee->email . PHP_EOL;

                   file_put_contents($file, $contents);
                }
                $contents = implode(PHP_EOL, $contents);
                $data = $file_name;
//                $data = [$contents, $file_name];
//                chmod($file,0777);

                return $data;
            }

        }
        else
        {
            if (!mkdir($writeDirPath) || !chmod($writeDirPath, 0775))
            {
                throw new \yii\base\UserException("Create directory error: $writeDirPath");
            }
        }
    }

    public function sendMail($mailFrom,$mailTo,$mail_cc,$mailSubject,$mailBody)
    {
        $mail = \Yii::$app->mailer->compose();

              $mail->setFrom($mailFrom);
              $mail->setTo($mailTo);
              $mail->setCc($mail_cc);
              $mail->setSubject($mailSubject);
              $mail->setHtmlBody($mailBody);
              $mail->send();
    }

//    public function findModel($id)
//    {
//        if (($model = RequestLog::find()->where(['request_id'=>$id])->orderBy(['id'=>SORT_DESC]))->one() !== null)
//        {
//            echo'<pre>'; print_R($model); exit;
//            return $model;
//        }
//
//        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
//    }

    public function findList($q = null)
    {
        $query = new \yii\db\Query();
        $query->select('*')->from('TableMaster');
        $data = $query->all();
//      $tableList = \yii\helpers\ArrayHelper::map(\app\models\TableMaster::find()->all(), 'id', 'name');
        return json_encode($data);
    }

    public function actionFindRequestService()
    {
        $data = $_POST['requestType'];
        $serviceList = RequestServiceMaster::find()->where('type_id = :type_id', [':type_id' => $data])->all();
        echo "<option value='0'>-- Select --</option>";

          foreach ($serviceList as $service)
          {
                echo "<option value='" . $service->id. "'>" . $service->name . "</option>";
          }
    }

    public function actionMysqlField()
    {
        $counter = !empty($_POST['counter']) ? $_POST['counter'] : 0;
        $modelRequest = new RequestDetail();
        return $this->renderPartial('_subform',[
             'modelRequest' => $modelRequest,
             'counter' => $counter,
            ]);
    }

    public function actionChangePassword()
    {
        $model = Employee::findEmployee(Yii::$app->user->identity->id);
        $error = '';
        if(\Yii::$app->request->post())
        {
           $current_password = $_POST['current-password'];
           $password = $_POST['Employee']['password'];
           $confirm_password = $_POST['confirm-password'];
           $current_password_valid = $model->password === sha1($current_password) ? true : false;

           $flag = 0;
           if($current_password_valid)
           {
               $valid = !empty($password) && !empty($confirm_password) ? true : $model->addError('*', 'Password Cannot be blank');

               $valid1 = (preg_match('/^(?=.*\d)(?=.*[A-Za-z])[0-9A-Za-z!_.:;@#$%]{8,}$/', $password)) ? true :  $model->addError('*', 'Password not in given pattern');
//               print_R($valid1); exit;
               $valid2 = (\strcmp($password,$confirm_password) === 0) ? true : $model->addError('*', 'Password & Confirm password are not same');

               $valid3 = (sha1($password) !== $model->password  && sha1($confirm_password) !== $model->password) ? true : $model->addError('*', 'Current Password cannot be Re-Entered');


               if($valid1 && $valid2 && $valid3)
               {
                    $model->password = sha1($password);
                    $flag = 1;
                    $model->save(false);
                    Yii::$app->session->setFlash('success','Password Updated Successfully');
                    return $this->redirect(['site/index','flag' => $flag]);
               }
           }
           else
           {
                    $model->addError('*','Current Password is Incorrect');
           }
        }
        return $this->render('_changePassword',['model'=>$model,'error' => $error]);
    }

    public function actionValidatePassword()
    {
        $password = !empty($_POST['current_password']) ? $_POST['current_password'] : 0;
        $flag = 0;
        $model = Employee::findEmployee(Yii::$app->user->identity->id);
        if($model->password === sha1($password))
        {
            $flag = 1;
            return $flag;
        }
        else
        {
            return $model->addError('*','Cannot be blank');
        }
    }

}
