-- MySQL dump 10.13  Distrib 5.7.41, for Linux (x86_64)
--
-- Host: localhost    Database: Qbrik
-- ------------------------------------------------------
-- Server version	5.7.41

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `AccessMaster`
--

DROP TABLE IF EXISTS `AccessMaster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AccessMaster` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ClientMaster`
--

DROP TABLE IF EXISTS `ClientMaster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ClientMaster` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `code` varchar(10) NOT NULL,
  `client_manager` int(2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `client_manager` (`client_manager`),
  CONSTRAINT `ClientMaster_ibfk_1` FOREIGN KEY (`client_manager`) REFERENCES `Employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `Employee`
--

DROP TABLE IF EXISTS `Employee`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Employee` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `employee_code` varchar(7) NOT NULL,
  `blood_group` varchar(5) DEFAULT NULL,
  `email` varchar(50) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `password` varchar(160) DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `is_active` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `employee_code` (`employee_code`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `EmployeeInfo`
--

DROP TABLE IF EXISTS `EmployeeInfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `EmployeeInfo` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `employee_id` int(4) NOT NULL,
  `access_username` varchar(10) NOT NULL,
  `address` varchar(200) NOT NULL,
  `contact_number` varchar(10) NOT NULL,
  `emergency_contact_name` varchar(30) DEFAULT NULL,
  `emergency_contact_number` varchar(10) DEFAULT NULL,
  `effective_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_id` (`employee_id`),
  CONSTRAINT `EmployeeInfo_ibfk_1` FOREIGN KEY (`employee_id`) REFERENCES `Employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `EmployeeRole`
--

DROP TABLE IF EXISTS `EmployeeRole`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `EmployeeRole` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `employee_id` int(2) NOT NULL,
  `role_id` int(2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_id` (`employee_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `EmployeeRole_ibfk_1` FOREIGN KEY (`employee_id`) REFERENCES `Employee` (`id`),
  CONSTRAINT `EmployeeRole_ibfk_2` FOREIGN KEY (`role_id`) REFERENCES `RoleMaster` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `InstanceMaster`
--

DROP TABLE IF EXISTS `InstanceMaster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `InstanceMaster` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `PrivilegeMaster`
--

DROP TABLE IF EXISTS `PrivilegeMaster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PrivilegeMaster` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `RequestDetail`
--

DROP TABLE IF EXISTS `RequestDetail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `RequestDetail` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `request_id` int(2) NOT NULL,
  `table_id` int(2) NOT NULL,
  `privilege_id` int(2) NOT NULL,
  `column_name` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `request_id` (`request_id`),
  KEY `privilege_id` (`privilege_id`),
  KEY `table_id` (`table_id`),
  CONSTRAINT `RequestDetail_ibfk_1` FOREIGN KEY (`request_id`) REFERENCES `RequestMaster` (`id`),
  CONSTRAINT `RequestDetail_ibfk_2` FOREIGN KEY (`privilege_id`) REFERENCES `PrivilegeMaster` (`id`),
  CONSTRAINT `RequestDetail_ibfk_3` FOREIGN KEY (`table_id`) REFERENCES `TableMaster` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `RequestLog`
--

DROP TABLE IF EXISTS `RequestLog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `RequestLog` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `request_id` int(2) NOT NULL,
  `message` varchar(200) DEFAULT NULL,
  `posting_time` datetime NOT NULL,
  `file_path` varchar(100) DEFAULT NULL,
  `status_id` int(2) NOT NULL,
  `user_id` int(2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `request_id` (`request_id`),
  KEY `status_id` (`status_id`),
  KEY `request_handler_id` (`user_id`),
  CONSTRAINT `RequestLog_ibfk_1` FOREIGN KEY (`request_id`) REFERENCES `RequestMaster` (`id`),
  CONSTRAINT `RequestLog_ibfk_2` FOREIGN KEY (`status_id`) REFERENCES `RequestStatusMaster` (`id`),
  CONSTRAINT `RequestLog_ibfk_3` FOREIGN KEY (`user_id`) REFERENCES `Employee` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `RequestMaster`
--

DROP TABLE IF EXISTS `RequestMaster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `RequestMaster` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `employee_id` int(2) NOT NULL,
  `request_type_id` int(1) NOT NULL,
  `request_service_id` int(1) NOT NULL,
  `client_id` int(2) DEFAULT NULL,
  `instance_id` int(2) DEFAULT NULL,
  `posting_time` datetime NOT NULL,
  `status_id` int(2) NOT NULL,
  `number_of_days` int(2) DEFAULT NULL,
  `message` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_id` (`employee_id`),
  KEY `request_type_id` (`request_type_id`),
  KEY `request_service_id` (`request_service_id`),
  KEY `client_id` (`client_id`),
  KEY `instance_id` (`instance_id`),
  KEY `status_id` (`status_id`),
  CONSTRAINT `RequestMaster_ibfk_1` FOREIGN KEY (`employee_id`) REFERENCES `Employee` (`id`),
  CONSTRAINT `RequestMaster_ibfk_2` FOREIGN KEY (`request_type_id`) REFERENCES `RequestTypeMaster` (`id`),
  CONSTRAINT `RequestMaster_ibfk_3` FOREIGN KEY (`request_service_id`) REFERENCES `RequestServiceMaster` (`id`),
  CONSTRAINT `RequestMaster_ibfk_4` FOREIGN KEY (`client_id`) REFERENCES `ClientMaster` (`id`),
  CONSTRAINT `RequestMaster_ibfk_5` FOREIGN KEY (`instance_id`) REFERENCES `InstanceMaster` (`id`),
  CONSTRAINT `RequestMaster_ibfk_6` FOREIGN KEY (`status_id`) REFERENCES `RequestStatusMaster` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `RequestServiceMaster`
--

DROP TABLE IF EXISTS `RequestServiceMaster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `RequestServiceMaster` (
  `id` int(1) NOT NULL AUTO_INCREMENT,
  `name` varchar(15) NOT NULL,
  `type_id` int(2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_id` (`type_id`),
  CONSTRAINT `RequestServiceMaster_ibfk_1` FOREIGN KEY (`type_id`) REFERENCES `RequestTypeMaster` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `RequestStatusMaster`
--

DROP TABLE IF EXISTS `RequestStatusMaster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `RequestStatusMaster` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `RequestTypeMaster`
--

DROP TABLE IF EXISTS `RequestTypeMaster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `RequestTypeMaster` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `RoleAccessMap`
--

DROP TABLE IF EXISTS `RoleAccessMap`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `RoleAccessMap` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `role_id` int(2) NOT NULL,
  `access_id` int(2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `role_id` (`role_id`),
  KEY `access_id` (`access_id`),
  CONSTRAINT `RoleAccessMap_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `RoleMaster` (`id`),
  CONSTRAINT `RoleAccessMap_ibfk_2` FOREIGN KEY (`access_id`) REFERENCES `AccessMaster` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `RoleMaster`
--

DROP TABLE IF EXISTS `RoleMaster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `RoleMaster` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `TableMaster`
--

DROP TABLE IF EXISTS `TableMaster`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `TableMaster` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-05-30 11:35:52
