<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "{{%AccessMaster}}".
 *
 * @property int $id
 * @property string $name
 *
 * @property RoleAccessMap[] $roleAccessMaps
 */
class AccessMaster extends \yii\db\ActiveRecord
{
    CONST LIST_EMPLOYEE = 'List Employee';
    CONST CREATE_EMPLOYEE = 'Create Employee';
    CONST DELETE_EMPLOYEE = 'Delete Employee';
    CONST RESET_PASSWORD = 'Reset Password';
    CONST CREATE_TABLE = 'Create Table';  
    CONST UPDATE_TABLE = 'Update Table';  
    CONST CREATE_CLIENT = 'Create Client'; 
    CONST UPDATE_CLIENT = 'Update Client'; 
    CONST APPROVE_REQUEST = 'Approve Request';
    CONST DECLINE_REQUEST = 'Decline Request';
    CONST REJECT_REQUEST = 'Reject Request';
    CONST VIEW_MASTER = 'View Master';
    CONST VIEW_REQUEST = 'View Request';
    CONST VIEW_TABLE = 'View Table';
    CONST VIEW_CLIENT = 'View Client';
    
    public static function tableName()
    {
        return '{{%AccessMaster}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['name'], 'string', 'max' => 15],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Access',
        ];
    }

    /**
     * Gets query for [[RoleAccessMaps]].
     *
     * @return \yii\db\ActiveQuery|RoleAccessMapQuery
     */
    public function getRoleAccessMaps()
    {
        return $this->hasMany(RoleAccessMap::class, ['access_id' => 'id']);
    }

    /**
     * {@inheritdoc}
     * @return AccessMasterQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new AccessMasterQuery(get_called_class());
    }
}
