<?php

namespace app\models;

use Yii;
use yii\validators\EmailValidator;
use yii\helpers\ArrayHelper;
use yii\validators\RegularExpressionValidator;

/**
 * This is the model class for table "{{%Employee}}".
 *
 * @property int $id
 * @property string $name
 * @property string $employee_code
 * @property string $blood_group
 * @property string $email
 * @property string|null $created_at
 * @property string $password
 * @property datetime $last_login
 * @property int $is_active
  *
 * @property ClientMaster[] $clientMasters
 * @property EmployeeInfo[] $employeeInfos
 * @property EmployeeRole[] $employeeRole
 * @property RequestMaster[] $requestMasters
 * @property RoleMaster $role
 */
class Employee extends \yii\db\ActiveRecord implements \yii\web\IdentityInterface
{
    /**
     * {@inheritdoc}
     */
    CONST project_name = 'Beeline';
    public static function tableName()
    {
        return '{{%Employee}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        $validator = RegularExpressionValidator::class;
        return [
            [['name', 'employee_code', 'email'], 'required'],
            [['created_at','name','blood_group','last_login','is_active'], 'safe'],
            [['name'], 'string', 'max' => 30],
            [['employee_code'], 'string', 'max' => 7],
            [['blood_group'], 'string', 'max' => 5],
            [['email'], 'string', 'max' => 50],
            [['password'],'string', 'max' => 160],
            [['employee_code','email'], 'unique'],
            ['name',$validator, 'pattern' => '/^[A-Za-z_\s]+$/', 'message' => 'Enter Valid Name',],
            ['employee_code',$validator, 'pattern' => '/^Q00+[0-9]{2}$/i', 'message' => 'Please enter a valid employee code ',],
            ['email', EmailValidator::class, 'pattern' => '/^[a-z_]+@qbrik\.in$/i', 'message' => 'Please enter a valid email address.',],
            ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'employee_code' => 'Code',
            'blood_group' => 'Blood Group',
            'email' => 'Email',
            'created_at' => 'Created At',
        ];
    }

    /**
     * Gets query for [[ClientMasters]].
     *
     * @return \yii\db\ActiveQuery|ClientMasterQuery
     */
    public function getClientMasters()
    {
        return $this->hasMany(ClientMaster::class, ['client_manager' => 'id']);
    }

    /**
     * Gets query for [[EmployeeInfos]].
     *
     * @return \yii\db\ActiveQuery|EmployeeInfoQuery
     */
    public function getEmployeeInfos()
    {
        return $this->hasMany(EmployeeInfo::class, ['employee_id' => 'id']);
    }

    /**
     * Gets query for [[RequestMasters]].
     *
     * @return \yii\db\ActiveQuery|RequestMasterQuery
     */
    public function getRequestMasters()
    {
        return $this->hasMany(RequestMaster::class, ['employee_id' => 'id']);
    }

    /**
     * {@inheritdoc}
     * @return EmployeeQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new EmployeeQuery(get_called_class());
    }

    public function getEmployeeRole()
    {
        return $this->hasMany(EmployeeRole::class, ['employee_id' => 'id']);
    }

    public function employeeList()
    {
        return ArrayHelper::map(Employee::find()->where("is_active=:is_active", [':is_active' => 1])->all(), 'id', 'name');
    }

    public static function findIdentity($id)
    {
       return static::findOne($id); /* return isset(self::$users[$id]) ? new static(self::$users[$id]) : null; */
    }

    public function findEmployee($id = null)
    {
        //Employee id used in where condition to take employee detail.

        $employeeModel = empty($id) ? Employee::find()->where('id = :id', array(':id' => Yii::$app->user->identity->id))->one() :  Employee::find()->where('id = :id', array(':id' => $id))->one();
        return $employeeModel;
    }

     public static function findIdentityByAccessToken($token, $type = null)      // Difference  in Asha Code
    {
        foreach (self::$users as $user) {
            if ($user['accessToken'] === $token) {
                return new static($user);
            }
        }

        return null;
    }

    public function getId()
    {
        return $this->id;
    }


    public function getAuthKey()
    {
//        return $this->authKey;
    }


    public function validateAuthKey($authKey)
    {
//        return $this->authKey === $authKey;
    }


    public function validatePassword($password)
    {
//        return $this->password === $password;
    }

    public function passwordValidation($password)
    {

    }

}
