<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "EmployeeRole".
 *
 * @property int $id
 * @property int $employee_id
 * @property int $role_id
 *
 * @property Employee $employee
 * @property RoleMaster $role
 */
class EmployeeRole extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'EmployeeRole';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['employee_id', 'role_id'], 'required'],
            [['employee_id', 'role_id'], 'integer'],
            [['employee_id'], 'exist', 'skipOnError' => true, 'targetClass' => Employee::class, 'targetAttribute' => ['employee_id' => 'id']],
            [['role_id'], 'exist', 'skipOnError' => true, 'targetClass' => RoleMaster::class, 'targetAttribute' => ['role_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'employee_id' => 'Employee ',
            'role_id' => 'Role',
        ];
    }

    /**
     * Gets query for [[Employee]].
     *
     * @return \yii\db\ActiveQuery|EmployeeQuery
     */
    public function getEmployee()
    {
        return $this->hasOne(Employee::class, ['id' => 'employee_id']);
    }

    /**
     * Gets query for [[Role]].
     *
     * @return \yii\db\ActiveQuery|RoleMasterQuery
     */
    public function getRole()
    {
        return $this->hasOne(RoleMaster::class, ['id' => 'role_id']);
    }

    /**
     * {@inheritdoc}
     * @return EmployeeRoleQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new EmployeeRoleQuery(get_called_class());
    }
}
