<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "{{%InstanceMaster}}".
 *
 * @property int $id
 * @property string $name
 *
 * @property RequestMaster[] $requestMasters
 */
class InstanceMaster extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%InstanceMaster}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['name'], 'string', 'max' => 15],l
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Instance',
        ];
    }

    /**
     * Gets query for [[RequestMasters]].
     *
     * @return \yii\db\ActiveQuery|RequestMasterQuery
     */
    public function getRequestMasters()
    {
        return $this->hasMany(RequestMaster::class, ['instance_id' => 'id']);
    }

    /**
     * {@inheritdoc}
     * @return InstanceMasterQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new InstanceMasterQuery(get_called_class());
    }
}
