<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "{{%PrivilegeMaster}}".
 *
 * @property int $id
 * @property string $name
 *
 * @property RequestDetail[] $requestDetails
 */
class PrivilegeMaster extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%PrivilegeMaster}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['name'], 'string', 'max' => 15],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Privilege',
        ];
    }

    /**
     * Gets query for [[RequestDetails]].
     *
     * @return \yii\db\ActiveQuery|RequestDetailQuery
     */
    public function getRequestDetails()
    {
        return $this->hasMany(RequestDetail::class, ['privilege_id' => 'id']);
    }

    /**
     * {@inheritdoc}
     * @return PrivilegeMasterQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new PrivilegeMasterQuery(get_called_class());
    }
    
    public static function getPrivilegeList()
    {
        $list = static::find()->all(); 
        return \yii\helpers\ArrayHelper::map($list, 'id', 'name');
    }        
}
