<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "{{%RequestDetail}}".
 *
 * @property int $id
 * @property int $request_id
 * @property int $table_id
 * @property int $privilege_id
 * @property string|null $column_name
 *
 * @property PrivilegeMaster $privilege
 * @property RequestMaster $request
 * @property TableMaster $table
 */
class RequestDetail extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%RequestDetail}}';
    }
      CONST SCENARIO_MYSQL = 'Mysql';
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['request_id', 'table_id', 'privilege_id'], 'integer'],
            [['column_name'], 'string', 'max' => 100],
            [['table_id', 'privilege_id'],'required','on' => self::SCENARIO_MYSQL,], /* ,'on' => self::SCENARIO_MYSQL */
            [['column_name'],'validateColumn'],
            [['request_id'], 'exist', 'skipOnError' => true, 'targetClass' => RequestMaster::class, 'targetAttribute' => ['request_id' => 'id']],
            [['privilege_id'], 'exist', 'skipOnError' => true, 'targetClass' => PrivilegeMaster::class, 'targetAttribute' => ['privilege_id' => 'id']],
            [['table_id'], 'exist', 'skipOnError' => true, 'targetClass' => TableMaster::class, 'targetAttribute' => ['table_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'request_id' => Yii::t('app', 'Request'),
            'table_id' => Yii::t('app', 'Table'),
            'privilege_id' => Yii::t('app', 'Privilege'),
            'column_name' => Yii::t('app', 'Column(*for multiple column use",")'),
        ];
    }

    /**
     * Gets query for [[Privilege]].
     *
     * @return \yii\db\ActiveQuery|PrivilegeMasterQuery
     */
    public function getPrivilege()
    {
        return $this->hasOne(PrivilegeMaster::class, ['id' => 'privilege_id']);
    }

    /**
     * Gets query for [[Request]].
     *
     * @return \yii\db\ActiveQuery|RequestMasterQuery
     */
    public function getRequest()
    {
        return $this->hasOne(RequestMaster::class, ['id' => 'request_id']);
    }

    /**
     * Gets query for [[Table]].
     *
     * @return \yii\db\ActiveQuery|TableMasterQuery
     */
    public function getTable()
    {
        return $this->hasOne(TableMaster::class, ['id' => 'table_id']);
    }

    /**
     * {@inheritdoc}
     * @return RequestDetailQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new RequestDetailQuery(get_called_class());
    }
    
    public function validateColumn($attribute)
    {
        if( empty($this->privilege_id) || $this->privilege_id != 2 )
        {
            $this->addError($attribute,'Column cannot be blank');
        }
    }    
}
