<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "{{%RequestMaster}}".
 *
 * @property int $id
 * @property int $employee_id
 * @property int $request_type_id
 * @property int $request_service_id
 * @property int|null $client_id
 * @property int|null $instance_id
 * @property string $posting_time
 * @property int $status_id
 * @property int $number_of_days
 * @property string $message
 *
 * @property ClientMaster $client
 * @property Employee $employee
 * @property InstanceMaster $instance
 * @property RequestDetail[] $requestDetails
 * @property RequestLog[] $requestLogs
 * @property RequestServiceMaster $requestService
 * @property RequestTypeMaster $requestType
 * @property RequestStatusMaster $status
 */
class RequestMaster extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%RequestMaster}}';
    }
    CONST NEW_STATUS = 'New';
    CONST new = 1;
    CONST approve = 2;
    CONST decline = 5;
    CONST revoke = 4;
    CONST APPROVED_STATUS = 'Approved';
    CONST REVOKED_STATUS = 'Revoked';
    CONST DECLINED_STATUS = 'Declined';
    CONST APPLIED_STATUS = 'Applied';
    CONST SCENARIO_ACCESS = 'ACCESS';
    CONST MYSQL = 2;

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return
        [
            [['employee_id', 'request_type_id', 'request_service_id', 'posting_time',], 'required'],
            [['employee_id', 'request_type_id', 'request_service_id', 'client_id', 'instance_id', 'status_id'], 'integer'],
            [['posting_time', 'number_of_days'], 'safe'],
            [['client_id', 'instance_id'],'validateServerRequest','on' => self::SCENARIO_ACCESS,'skipOnEmpty' => $this->request_type_id != 1 ? false : true,],
//            [['number_of_days'],'validateNumberofDays','skipOnEmpty' => false],
            [['message'],'required','when'=> function($model){
                     if(empty($this->request_type_id) || empty($this->request_service_id))
                     {
                         return false;
                     }
                     else
                     {
                         return true;
                     }
            }],
            [['employee_id'], 'exist', 'skipOnError' => true, 'targetClass' => Employee::class, 'targetAttribute' => ['employee_id' => 'id']],
            [['request_type_id'], 'exist', 'skipOnError' => true, 'targetClass' => RequestTypeMaster::class, 'targetAttribute' => ['request_type_id' => 'id']],
            [['request_service_id'], 'exist', 'skipOnError' => true, 'targetClass' => RequestServiceMaster::class, 'targetAttribute' => ['request_service_id' => 'id']],
            [['client_id'], 'exist', 'skipOnError' => true, 'targetClass' => ClientMaster::class, 'targetAttribute' => ['client_id' => 'id']],
            [['instance_id'], 'exist', 'skipOnError' => true, 'targetClass' => InstanceMaster::class, 'targetAttribute' => ['instance_id' => 'id']],
                [['status_id'], 'exist', 'skipOnError' => true, 'targetClass' => RequestStatusMaster::class, 'targetAttribute' => ['status_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'Request #'),
            'employee_id' => Yii::t('app', 'Name '),
            'request_type_id' => Yii::t('app', 'Type'),
            'request_service_id' => Yii::t('app', 'Access For '),
            'client_id' => Yii::t('app', 'Client'),
            'instance_id' => Yii::t('app', 'Instance'),
            'posting_time' => Yii::t('app', 'Posting Time'),
            'status_id' => Yii::t('app', 'Status'),
            'number_of_days' => Yii::t('app', 'Access Needed Until'),
            'message' => Yii::t('app', 'Reason For Access '),
        ];
    }

    /**
     * Gets query for [[Client]].
     *
     * @return \yii\db\ActiveQuery|ClientMasterQuery
     */
    public function getClient()
    {
        return $this->hasOne(ClientMaster::class, ['id' => 'client_id']);
    }

    /**
     * Gets query for [[Employee]].
     *
     * @return \yii\db\ActiveQuery|EmployeeQuery
     */
    public function getEmployee()
    {
        return $this->hasOne(Employee::class, ['id' => 'employee_id']);
    }

    /**
     * Gets query for [[Instance]].
     *
     * @return \yii\db\ActiveQuery|InstanceMasterQuery
     */
    public function getInstance()
    {
        return $this->hasOne(InstanceMaster::class, ['id' => 'instance_id']);
    }

    /**
     * Gets query for [[RequestDetails]].
     *
     * @return \yii\db\ActiveQuery|RequestDetailQuery
     */
    public function getRequestDetails()
    {
        return $this->hasMany(RequestDetail::class, ['request_id' => 'id']);
    }

    /**
     * Gets query for [[RequestLogs]].
     *
     * @return \yii\db\ActiveQuery|RequestLogQuery
     */
    public function getRequestLogs()
    {
        return $this->hasMany(RequestLog::class, ['request_id' => 'id']);
    }

    /**
     * Gets query for [[RequestService]].
     *
     * @return \yii\db\ActiveQuery|RequestServiceMasterQuery
     */
    public function getRequestService()
    {
        return $this->hasOne(RequestServiceMaster::class, ['id' => 'request_service_id']);
    }

    /**
     * Gets query for [[Status]].
     *
     * @return \yii\db\ActiveQuery|RequestStatusMasterQuery
     */
    public function getStatus()
    {
        return $this->hasOne(RequestStatusMaster::class, ['id' => 'status_id']);
    }

    /**
     * Gets query for [[RequestType]].
     *
     * @return \yii\db\ActiveQuery|RequestTypeMasterQuery
     */
    public function getRequestType()
    {
        return $this->hasOne(RequestTypeMaster::class, ['id' => 'request_type_id']);
    }

    /**
     * {@inheritdoc}
     * @return RequestMasterQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new RequestMasterQuery(get_called_class());
    }

    public function getNewStatus($status)
    {
        if(strcmp($status,RequestMaster::NEW_STATUS) === 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    public function getDeclineStatus($status)
    {
        if(strcmp($status,RequestMaster::REVOKED_STATUS) !== 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    public function validateNumberofDays($attribute)
    {
        if(!empty($this->request_type_id) && !empty($this->request_service_id))
        {
            return empty($this->number_of_days) ?  $this->addError($attribute,'Number of Days cannot be blank') : true;
        }
    }

    public function validateServerRequest($attribute)
    {
        if((empty($this->client_id) || empty($this->instance_id)) && (!empty($this->request_type_id) && !empty($this->request_service_id)))
        {
            $this->addError($attribute,'Fields cannot be blank');
        }
    }

    public function getCurrentRequestLogDetail($id)
    {
        $query = RequestLog::find()->where(['request_id'=>$id])->orderBy(['id'=>SORT_DESC])->one();
        return $query;
    }
}
