<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\RequestMaster;
use app\models\Employee;

/**
 * RequestMasterSearch represents the model behind the search form of `app\models\RequestMaster`.
 */
class RequestMasterSearch extends RequestMaster
{
    /**
     * {@inheritdoc}
     */
    public $name;

    public function rules()
    {
        return [
            [['id', 'employee_id', 'request_type_id', 'request_service_id', 'client_id', 'instance_id', 'status_id'], 'integer'],
            [['employee_id', 'request_type_id', 'request_service_id', 'client_id', 'instance_id',' posting_time','name'], 'safe'],
//            ['status' => ['New', 'Approved','Revoked','Declined'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */

    public function search($params)
    {
        $query = RequestMaster::find();
        // add conditions that should always apply here


        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [ 'pageSize' => 10 ],
            'sort' => ['defaultOrder' => ['id' => SORT_DESC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'employee_id' => $this->employee_id,
            'request_type_id' => $this->request_type_id,
            'request_service_id' => $this->request_service_id,
            'client_id' => $this->client_id,
            'instance_id' => $this->instance_id,
            'posting_time' => $this->posting_time,
            'status_id' => $this->status_id,
            'message' => $this->message,

        ]);

        return $dataProvider;
    }
}
