<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "{{%RequestServiceMaster}}".
 *
 * @property int $id
 * @property string $name
 *
 * @property RequestMaster[] $requestMasters
 */
class RequestServiceMaster extends \yii\db\ActiveRecord
{
//    CONST SERVER = 'SSH';
    CONST MYSQL = 'Mysql';
    CONST VPN = 'VPN';
    CONST SSH = 'SSH';

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%RequestServiceMaster}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['type_id'], 'integer'],
            [['name'], 'string', 'max' => 15],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Access For',
        ];
    }

    /**
     * Gets query for [[RequestMasters]].
     *
     * @return \yii\db\ActiveQuery|RequestMasterQuery
     */
    public function getRequestMasters()
    {
        return $this->hasMany(RequestMaster::class, ['request_service_id' => 'id']);
    }

    public function getType()
    {
        return $this->hasOne(RequestTypeMaster::class, ['id' => 'type_id']);
    }

    /**
     * {@inheritdoc}
     * @return RequestServiceMasterQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new RequestServiceMasterQuery(get_called_class());
    }

}
