<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "{{%RequestTypeMaster}}".
 *
 * @property int $id
 * @property string $name
 *
 * @property RequestMaster[] $requestMasters
 */
class RequestTypeMaster extends \yii\db\ActiveRecord
{
    const accessRequest = 1;
    const assetRequest = 2;
    const ACCESS_REQUEST = "Access Request";
    const ASSET_REQUEST = "Asset Request";

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%RequestTypeMaster}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['name'], 'string', 'max' => 15],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Type',
        ];
    }

    /**
     * Gets query for [[RequestMasters]].
     *
     * @return \yii\db\ActiveQuery|RequestMasterQuery
     */
    public function getRequestMasters()
    {
        return $this->hasMany(RequestMaster::class, ['request_type_id' => 'id']);
    }

    public function getRequestServiceMasters()
    {
        return $this->hasMany(RequestServiceMaster::class, ['type_id' => 'id']);
    }

    /**
     * {@inheritdoc}
     * @return RequestTypeMasterQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new RequestTypeMasterQuery(get_called_class());
    }
}
