<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "{{%RoleAccessMap}}".
 *
 * @property int $id
 * @property int $role_id
 * @property int $access_id
 *
 * @property AccessMaster $access
 * @property RoleMaster $role
 */
class RoleAccessMap extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%RoleAccessMap}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['role_id', 'access_id'], 'required'],
            [['role_id', 'access_id'], 'integer'],
            [['role_id'], 'exist', 'skipOnError' => true, 'targetClass' => RoleMaster::class, 'targetAttribute' => ['role_id' => 'id']],
            [['access_id'], 'exist', 'skipOnError' => true, 'targetClass' => AccessMaster::class, 'targetAttribute' => ['access_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'role_id' => 'Role ID',
            'access_id' => 'Access ID',
        ];
    }

    /**
     * Gets query for [[Access]].
     *
     * @return \yii\db\ActiveQuery|AccessMasterQuery
     */
    public function getAccess()
    {
        return $this->hasOne(AccessMaster::class, ['id' => 'access_id']);
    }

    /**
     * Gets query for [[Role]].
     *
     * @return \yii\db\ActiveQuery|RoleMasterQuery
     */
    public function getRole()
    {
        return $this->hasOne(RoleMaster::class, ['id' => 'role_id']);
    }

    /**
     * {@inheritdoc}
     * @return RoleAccessMapQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new RoleAccessMapQuery(get_called_class());
    }
}
