<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "{{%RoleMaster}}".
 *
 * @property int $id
 * @property string $name
 *
 * @property Employee[] $employees
 * @property EmployeeRole[] $employeeRole
 * @property RoleAccessMap[] $roleAccessMaps
 */
class RoleMaster extends \yii\db\ActiveRecord
{

   CONST admin_mail = 'security@qbrik.in';
   CONST admin_cc_for_request =  array('bhaskar@qbrik.in', 'pradeep@qbrik.in','indrajith@qbrik.in','irudhayaraj@qbrik.in');
   CONST admin_cc_for_status =  array('security@qbrik.in','irudhayaraj@qbrik.in');
    CONST Admin = 1;
    CONST Manager = 2;
    CONST Developer = 3;

    public static function tableName()
    {
        return '{{%RoleMaster}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['name'], 'string', 'max' => 15],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Role',
        ];
    }

   /**
     * Gets query for [[EmployeeRole]].
     *
     * @return \yii\db\ActiveQuery|EmployeeRoleAccessQuery
     */
    public function getEmployeeRole()
    {
        return $this->hasMany(EmployeeRole::class, ['role_id' => 'id']);
    }

    /**
     * Gets query for [[RoleAccessMaps]].
     *
     * @return \yii\db\ActiveQuery|RoleAccessMapQuery
     */
    public function getRoleAccessMaps()
    {
        return $this->hasMany(RoleAccessMap::class, ['role_id' => 'id']);
    }

    /**
     * {@inheritdoc}
     * @return RoleMasterQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new RoleMasterQuery(get_called_class());
    }

 /*   public static function isUserAdmin($name , $password = null)
    {
       if (Employee::findOne(['email' => $name, 'role_id' => 1])){

        return true;
       }
       else {
        return false;
       }
    }
    public static function isUserManager($name)
    {
        if (Employee::findOne(['email' => $name, 'role_id' => 2])){
            return true;
        }
        else{
            return false;
        }
    }
    public static function isUserDeveloper($name)
    {
        if (Employee::findOne(['email' => $name, 'role_id' => 3])){
            return true;
        }
        else {
            return false;
        }
    }*/
}
?>
