<?php

namespace app\models;

use Yii;
use yii\validators\RegularExpressionValidator;

/**
 * This is the model class for table "{{%TableMaster}}".
 *
 * @property int $id
 * @property string $name
 *
 * @property RequestDetail[] $requestDetails
 */
class TableMaster extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%TableMaster}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['name'], 'string', 'max' => 50],
            ['name', RegularExpressionValidator::class,'pattern' => '/^[A-Za-z_\s]+$/', 'message' => 'Enter Valid name',],
            ['name','unique','targetAttribute' => 'name', 'message' => 'This data already exists'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'name' => Yii::t('app', 'Name'),
        ];
    }

    /**
     * Gets query for [[RequestDetails]].
     *
     * @return \yii\db\ActiveQuery|RequestDetailQuery
     */
    public function getRequestDetails()
    {
        return $this->hasMany(RequestDetail::class, ['table_id' => 'id']);
    }

    /**
     * {@inheritdoc}
     * @return TableMasterQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new TableMasterQuery(get_called_class());
    }
}
