<?php

namespace app\models;

use app\models\Employee;
use yii\db\ActiveRecord;
use yii\web\IdentityInterface;

class User extends ActiveRecord implements IdentityInterface
{
    public $authKey;
    public $accessToken;


    public static function findIdentity($id)
    {
       return Employee::findOne($id); /* return isset(self::$users[$id]) ? new static(self::$users[$id]) : null; */
    }

    public static function findIdentityByAccessToken($token, $type = null)      // Difference  in Asha Code 
    {
        foreach (self::$users as $user) {
            if ($user['accessToken'] === $token) {
                return new static($user);
            }
        }

        return null;
    }

    public static function findByUsername($username)
    {
         $user = Employee::find()
                ->where("email=:email and is_active = :is_active", [":email" => $username, ":is_active" => 1])
            ->one();
        return $user;
    }

    
    public function getId()
    {
        return  Employee::$id;
    }

    
    public function getAuthKey()
    {
        return $this->authKey;
    }


    public function validateAuthKey($authKey)
    {
        return $this->authKey === $authKey;
    }

    
    public function validatePassword($password)
    {
        return Employee::$password === $password;
    }
    
    
    public function encrypting($password)
    {
        $hash ='sha1';
        $encryptPswd = sha1($password);
        if ($hash=="md5") {
            $encryptPswd = md5($password); }
        elseif ($hash=="sha1") {
            $encryptPswd = sha1($password); }
        else {
            $encryptPswd = hash($hash,$password); }
        return $encryptPswd;
    }
    
}
