<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use app\models\AccessMaster;

/** @var yii\web\View $this */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Clients';
?>
<style>
    .grid-view .pagination li a {
  margin: 0 5px;
}
</style>
<div class="employee-index">

    <h1 >
        <?= Html::encode($this->title) ?> 
        <?php if(in_array(AccessMaster::CREATE_CLIENT, Yii::$app->session->get('actions'))) { ?>
        <?= Html::a('Create Client',['admin/client-create'], ['class' => 'btn btn-outline-success btn-sm','style' => 'float:right;']) ?>
        <?php } ?>
    
    </h1>
    <?=
        GridView::widget([
        'dataProvider' => $dataProvider,
       //'filterModel' => $searchModel,
        'columns' => [
 
            [
                'header' => 'Name',
                'attribute' => 'name',
            ],
            [
                'header' => 'Code',
                'attribute' => 'code',
            ],
            [
                'header' => 'Manager',
                'attribute' => 'clientManager.name',
            ],    
            [
                'class' => ActionColumn::className(),
                'header' => '<a style="color: #212529;">Action</a>',
                'template' => '{update}',
//                'visible' => RoleAccessMap::find()->where(['role_id'=>$role,'access_id'=> AccessMaster::UPDATE_CLIENT])->one() ? true : false,
                'buttons' => 
                [
                    'update' => function ($url, $model, $key) 
                    {
                        return  Html::a('Update',['admin/client-update','id' => $model->id]);
                    }
                ],
               /* 'urlCreator' => function ($action,$model) {
                        $action = 'admin/client-update';
                        $url = Url::toRoute([$action, 'id' => $model->id]);
                        return $url;
                } */       
            ],
        ],
    ]); ?>


</div>
