<?php

use yii\helpers\Html;
use app\models\RequestLog;
use yii\widgets\DetailView;
use yii\widgets\ActiveForm;
use yii\helpers\Url;
use app\models\RequestMaster;
use app\models\RequestServiceMaster;
use app\models\AccessMaster;

$this->title = 'Request Detail';

\yii\web\YiiAsset::register($this);

if($model->status->name == RequestMaster::APPROVED_STATUS)
{
    $Statusheader = 'Approved By';
}
elseif($model->status->name == RequestMaster::APPLIED_STATUS)
{
    $Statusheader = 'Applied By';
    $messageHeader = 'Reason For Applied';
}
elseif($model->status->name == RequestMaster::DECLINED_STATUS)
{
    $Statusheader = 'Declined By';
    $messageHeader = 'Reason For Declined';
}
else
{
    $Statusheader = 'Revoked By';
}

?>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script type="text/javascript">

     $(document).ready(function ()
     {
         var labels = document.querySelectorAll('label.control-label');
         $('#requestlog-message').hide();
         $('#decline-button2').hide();
         labels[0].style.display = 'none';
         $('#decline-button').click(function ()
         {
             labels[0].style.display = 'block';
             $('#decline-button').hide();
             $('#revoke-button').hide();
             $('#approve-button').hide();
             $('#decline-button2').show();
             $('#requestlog-message').show();

         });

     });

</script>

<div class="employee-view">

    <h2>
        <?= Html::encode($this->title) ?>
        <?= Html::a('Back',['admin/index'], ['class' => 'btn btn-outline-dark btn-sm','style' => 'float:right;']) ?>

    </h2>
    <?= DetailView::widget([
        'model' => $model,
        'attributes' =>
           [
                [
                    'label' => 'Request #',
                    'value' => function($model)
                        {
                            return $model->request->id;
                        }
                ],
                [
                    'label' => 'Name',
                     'value'=> function($model)
                        {
                            return $model->request->employee->name;
                        }
                ],
                [
                    'label' => 'Username',
                    'visible' => (($model->request->requestService->name != RequestServiceMaster::VPN)) ? true : false,
                     'value'=> function($model)
                        {
                            return $model->request->employee->employeeInfos[0]->access_username;
                        }

                ],
                [
                    'label' => 'Request Type',
                     'value'=> function($model)
                        {
                            return $model->request->requestType->name;
                        }
                ],
                [
                    'label' => 'Request For',
                     'value'=> function($model)
                        {
                            return $model->request->requestService->name;
                        }
                ],
                [
                    'attribute'=> 'client_id',
                    'label' => 'Client',
                    'visible' =>(!empty($model->request->client)) ? true : false,
                    'value'=> function($model)
                        {
                            return $model->request->client->name;
                        }

                ],
                [
                    'attribute'=> 'instance_id',
                    'label' => 'Instance',
                    'visible' =>(!empty($model->request->instance)) ? true : false,
                    'value'=> function($model)
                        {
                            return $model->request->instance->name;
                        }

                ],
                [
                    'label' => 'Mysql Details',
                    'visible' =>(!empty($model->request->requestDetails)) ? true : false,
                    'value'=> function($model)
                     {
                              $items = $model->request->requestDetails;

                               foreach ($items as $item)
                               {
                                    $column = $item->privilege->name == 'Update' ? '('.$item->column_name .')':'';
                                    $mysqlFields[] = $item->privilege->name .' => '. $item->table->name . $column ;
                               }

                               return  "<pre>".implode(",\n",$mysqlFields)."</pre>";
                      },

                    'format' => 'html',
                ],
                [
                    'attribute' => 'posting_time',
                    'label' => 'Posting Time',
                    'value'=> function($model)
                    {
                        $value = strtotime($model->request->posting_time);
//                        $current_year = date("Y");
//                        $model = $current_year == date('Y',$value) ? date(' d M, g:i a',$value) : date('M d,Y g:i a',$value);
                        $dateTime = date('d/m/Y H:i:s', $value);
                        return $dateTime;
                    }

                ],
		[
    			'attribute' => 'file_path',
    			'label' => 'FilePath',
 			'format' => 'raw',
    			'visible' =>(!empty($model->file_path)) ? true : false,
                    'value' => function($model)
                    {
 			if($model->request->requestType->name != app\models\RequestTypeMaster::ACCESS_REQUEST)
			{
                        	$Filepath = \Yii::$app->basePath . '/files/' . RequestLog::Upload_File . '/' . $model->file_path ;
                        	return Html::a($model->file_path,['admin/file-download','Filepath' => $Filepath]);
		        }
			else
			{
				 return $model->file_path;
  			}
                    }
		],
                [
                    'attribute' => 'number_of_days',
                    'label' => 'Access Needed Until',
                    'value'=> function($model)
                    {
                        if(!empty($model->request->number_of_days))
                        {
   //                        $current_year = date("Y");
                           $value = strtotime($model->request->posting_time);
                           $date = date('d-m-Y', $value);
                           $date = date_create($date);
                           $days = $model->request->number_of_days -1;
                           $enddate = date_add($date, date_interval_create_from_date_string(" $days days"));
                           $date = date_format($enddate,"d/m/Y ");
                           return $date;
                        }
                        else
                        {
                            return 'Forever';
                        }
                     }
                ],
                [
                    'attribute'=> 'status_id',
                    'label' => 'Status',
                    'value'=> function($model)
                        {
                      return $model->request->status->name;
                    }
                ],
                [
                    'attribute'=> 'user_id',
                    'label' => $Statusheader,
                    'visible' => $model->status->name != RequestMaster::NEW_STATUS ? true : false,
                    'value'=> function($model)
                    {
                      return $model->user->name;
                    }
                ],
                [
                    'label' => 'Reason For Request',
                    'value'=> function($model)
                        {
                             return   $model->request->message;
                        }
                ],
                [
                    'label' => 'Reason For Decline',
                    'attribute' => 'message',
                    'visible' => $model->status->name == RequestMaster::DECLINED_STATUS ? true : false,
                    'value'=> function($model)
                        {
                             return   $model->message;
                        }
                ],


            ],
        'template' => '<tr><th style="width:20%;">{label}</th><td style="width:80%;">{value}</td></tr>',
    ]) ?>

<div style="float: right;">

    <?php if (in_array(AccessMaster::APPROVE_REQUEST, Yii::$app->session->get('actions')) && (strcmp($model->status->name, RequestMaster::NEW_STATUS) === 0))
    { ?>
        <?=   Html::a('Approve', ['admin/request-status', 'id' => $model->request->id,'flag' => RequestMaster::approve], ['class' => 'btn btn-outline-success','id' => 'approve-button','data' => [
                    'confirm' => 'Are you sure you want to approve this request ?',
                    'method' => 'post',
                ],]) ?>
        <?php } ?>
    <?php if (in_array(AccessMaster::REJECT_REQUEST, Yii::$app->session->get('actions')) && strcmp($model->status->name, RequestMaster::APPROVED_STATUS) === 0 || strcmp($model->status->name, RequestMaster::APPLIED_STATUS) === 0)
    { ?>
    <?=   Html::a('Revoke' , ['admin/request-status', 'id' => $model->request->id,'flag' => RequestMaster::revoke], ['class' => 'btn btn-outline-dark','id' => 'revoke-button'])?>
        <?php } ?>
    <?php if (in_array(AccessMaster::DECLINE_REQUEST, Yii::$app->session->get('actions')) && (strcmp($model->status->name, RequestMaster::NEW_STATUS) === 0 || strcmp($model->status->name, RequestMaster::APPROVED_STATUS) === 0))
    { ?>
        <span></span>
        <?php $form = ActiveForm::begin(['options'=>['style'=>'float:right;padding-left: 10px;',],'action' => 'decline-message'] ); ?>
        <?=   Html::button('Decline', ['class' => 'btn btn-outline-danger','id' => 'decline-button']) ?>
        <?=   $form->field($requestLog, 'message')->textarea() ?>
        <?= Html::submitButton('Send',['class' => 'btn btn-sm btn-outline-danger','id' => 'decline-button2','formaction' => Url::to(['admin/decline-message','id'=>$model->request->id]),]); ?>
        <?php ActiveForm::end(); ?>
        <?php } ?>
</div>
