<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use \app\models\RequestTypeMaster;
use \app\models\ClientMaster;
use app\models\InstanceMaster;
use app\models\RequestServiceMaster;

/** @var yii\web\View $this */
/** @var app\models\RequestMaster $model */
/** @var yii\widgets\ActiveForm $form */
?>
<style>
    .my-button{
        float: right;
    }
</style>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script type="text/javascript">

    $(document).ready(function ()
    {
        $('#addField').hide();
        $('#removeField-0').hide();
        $('.updateField').hide();
        $('#requestmaster-number_of_days').hide();
	<?php $DateArray = ['1' => 'Forever', '2' => 'Date Range']; $max = 0; ?>
        var labels = document.querySelectorAll('label.control-label');
        console.log(labels);
        var selectedOption = "<?php echo!empty($selectedType) ? $selectedType : '' ?>";
        var selectedId = "<?php echo!empty($selectedID) ? $selectedID : '' ?>";
        if ($.isEmptyObject(selectedOption))
        {
            loadHideFields(labels);
        } else
        {
            loadRequestService();
            setTimeout(function () {
                $('#requestmaster-request_service_id').val(selectedId);
            }, 500);
            hideAfterSelection(labels, selectedOption);
        }

        var counter = 0;

        $('#requestmaster-request_type_id').change(function () {

            if ($('#requestmaster-request_type_id').val())
            {
                loadRequestService();
            } else
            {
                loadHideFields(labels);
            }

        });

        $('#requestmaster-request_service_id').change(function () {
            hideAfterSelection(labels, selectedOption,selectedId);
        });

        $('#access_date_range').change(function ()
        {

            if ($('#access_date_range input[type="radio"]:checked').val() == '1')
            {
                $('#requestmaster-number_of_days').hide();
            } else
            {
                $('#requestmaster-number_of_days').show();
            }
        });


        $('#addField').click(function () {

            counter += 1;
            jQuery('<div>', {
                id: 'mysqlField-' + counter,
                class: 'row col-md-12'
            }).appendTo('#mysqlField-0');

            $.ajax({
                type: 'POST',
                url: "<?php echo Yii::$app->getUrlManager()->createUrl('request-master/mysql-field'); ?>",
                data: {counter: counter},
                success: function (response)
                {
                    $("#mysqlField-" + counter).html(response);
                }
            });
        });


    });

    function loadHideFields(labels)
    {
        var selectedTypeOption = $('#requestmaster-request_type_id').val();
        if (!selectedTypeOption)
        {
            $('#requestmaster-request_service_id').empty();
        }
        $("#requestmaster-client_id").hide();
        $("#requestmaster-instance_id").hide();
        $("#requestlog-file_path").hide();
        $("#mysqlField-0").hide();
        $("#requestmaster-message").hide();
        $("#access_date_range").hide();
        $('#requestmaster-number_of_days').hide();

        for (var i = 0; i < labels.length; i++)
        {
            if (i >= 2)
            {
                labels[i].style.display = 'none';
            }
        }
    }

    function loadRequestService()
    {
        var requestType = $('#' + 'requestmaster-request_type_id option:selected').val();
        $.ajax({
            type: 'POST',
            url: "<?php echo Yii::$app->getUrlManager()->createUrl('request-master/find-request-service'); ?>",
            data: {requestType: requestType},
            success: function (data)
            {
                $("#requestmaster-request_service_id").html(data);
            }
        });
    }

    function hideAfterSelection(labels, selectedOption)
    {
//           var label = $('label[for="requestmaster-message"]'); label.text('Message(Purpose of Request)');

       if(selectedOption === '')
       {
           var opt = $('#requestmaster-request_service_id').find('option:selected');
           selectedOption = opt.html();
       }

        var selectedTypeOption = $('#requestmaster-request_type_id').val();
        var type_opt = $('#requestmaster-request_type_id').find('option:selected');
        var selectedTypeData =  type_opt.html();

        if (!selectedTypeOption || selectedOption === '0')
        {
            loadHideFields(labels);
        } else if (selectedOption === "<?php echo RequestServiceMaster::MYSQL; ?>")
        {
	    <?php $max = 0; ?>
            $('#addField').show();
            $("#requestlog-file_path").hide();
            $("#access_date_range").show();
            $("#requestmaster-client_id").show();
            $("#requestmaster-instance_id").show();
            $("#mysqlField-0").show();
            $("#requestmaster-message").show();

            for (var i = 0; i < labels.length; i++)
            {
                if(i <= 5)
                {
                   labels[i].style.display = 'block';
               }
               else
               {
                   labels[i].style.display = 'none';
               }
            }

            $.ajax({
                type: 'POST',
                url: "<?php echo Yii::$app->getUrlManager()->createUrl('request-master/mysql-field'); ?>",
                success: function (response)
                {
                    $("#mysqlField-0").html(response);
                }
            });
        } else if (selectedOption === "<?php echo RequestServiceMaster::VPN; ?>" || selectedTypeData !== "<?php echo RequestTypeMaster::ACCESS_REQUEST; ?>")
        {
            $("#requestmaster-client_id").hide();
	    <?php $max = 0; ?>
            if(selectedTypeData !== "<?php echo RequestTypeMaster::ASSET_REQUEST; ?>" && selectedTypeData !== "<?php echo RequestTypeMaster::ACCESS_REQUEST; ?>")
            {
		var label = $('label[for="requestmaster-message"]'); label.text('Detail Information');
    		<?php $max = 60; ?>
                var label = $('label[for="radio-button"]'); label.text('Expire Days');
                $("#access_date_range").hide();
                $("#requestlog-file_path").show();
                $('#requestmaster-number_of_days').show();
            }
            else
            {
		 $("#access_date_range").show();
                 $("#requestlog-file_path").hide();
                 $('#requestmaster-number_of_days').hide();
            }
            $("#requestmaster-instance_id").hide();
            $("#mysqlField-0").hide();
            $("#addField").hide();
            $("#requestmaster-message").show();
            for (var i = 0; i < labels.length; i++)
            {
                if (i <= 1 || i > 3 && i !== 6)
                {
                    labels[i].style.display = 'block';
                } else
                {
                    labels[i].style.display = 'none';
                }
            }

        }
        else
        {
            $("#access_date_range").show();
            $("#requestlog-file_path").hide();
            $("#requestmaster-client_id").show();
            $("#requestmaster-instance_id").show();
            $("#requestmaster-message").show();
            $("#mysqlField-0").hide();
            $('#addField').hide();

            for (var i = 0; i < labels.length; i++)
            {
                if (i <= 5)
                {
//                       if(i == 5){ var label = $('label[for="requestmaster-message"]'); label.text('Client Refer MailId');} // ('Client Refer MailId');
                    labels[i].style.display = 'block';
                } else
                {
                    labels[i].style.display = 'none';
                           }
                       }
        }

    }

</script>

<?php $form = ActiveForm::begin(['enableClientValidation' => false,]); ?> <!-- 'options'=>['style'=>'width:500px;',], -->

<?php $common = ['prompt' => '-- Select --'];
?>

<?= $form->errorSummary([$model, $requestLog, $modelRequest]) ?>

<!--    <?= $form->field($modelEmployee, 'name')->hiddenInput(['readonly' => true])->label('') ?>

<?= $form->field($modelEmployee, 'employee_code')->hiddenInput(['readonly' => true])->label('') ?> -->

<?= $form->field($model, 'request_type_id')->dropDownList(ArrayHelper::map(RequestTypeMaster::find()->all(), 'id', 'name'), $common) ?>

<?= $form->field($model, 'request_service_id')->dropDownList($common) ?>

<?= $form->field($model, 'client_id')->dropDownList(ArrayHelper::map(ClientMaster::find()->all(), 'id', 'name'), $common) ?>

<?= $form->field($model, 'instance_id')->dropDownList(ArrayHelper::map(InstanceMaster::find()->all(), 'id', 'name'), $common) ?>

<div class="row " id="mysqlField-0">

</div>
<a class ="btn btn-sm btn-outline-primary" id="addField" > Add </a>
<?= $form->field($model, 'message')->textarea() ?>

<?= Html::label('Access Needed Until', 'radio-button', ['class' => 'control-label']) ?>
<?=
Html::radioList(
    'radio-button',
    [0],
    $DateArray,
    ['id' => 'access_date_range']
)
?>

<?php $model->number_of_days = date('Y-m-d'); ?>

<?=
$form->field($model, 'number_of_days')->widget(\yii\jui\DatePicker::className(),
    [
        'language' => 'en',
        'inline' => false,
        'options' => [
            'class' => 'form-control',
            'value' => '',
        ],
        'clientOptions' =>
        [
            'autoclose' => true,
            'showAnim' => 'fold',
            'minDate' => '0',
		 'maxDate'=>$max,
        ],])->label(false)
?>

<?= $form->field($requestLog, 'file_path')->fileInput() ?>

<div class="form-group">

    <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-outline-primary btn-sm']) ?>

    <?= Html::a('Cancel', ['/request-master/index', 'id' => $model->id], ['class' => 'btn btn-outline-secondary btn-sm']) ?>

</div>

    <?php ActiveForm::end(); ?>
