<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use app\models\RequestMaster;
use app\models\RequestServiceMaster;

/** @var yii\web\View $this */
/** @var app\models\RequestMaster $model */

$this->title = 'Request Detail';
$messageHeader = '';
if($model->status->name == RequestMaster::APPROVED_STATUS)
{
    $Statusheader = 'Approved By';
}
elseif($model->status->name == RequestMaster::APPLIED_STATUS)
{
    $Statusheader = 'Applied By';
    $messageHeader = 'Reason For Applied';
}
elseif($model->status->name == RequestMaster::DECLINED_STATUS)
{
    $Statusheader = 'Declined By';
    $messageHeader = 'Reason For Decline';
}
else
{
    $Statusheader = 'Revoked By';
}

\yii\web\YiiAsset::register($this);
?>
<div class="request-master-view">

    <h2>
        <?= Html::encode($this->title) ?>
        <?= Html::a('Back',['request-master/index'], ['class' => 'btn btn-outline-dark btn-sm','style' => 'float:right;']) ?>
    </h2>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' =>
           [
                [
                    'label' => 'Request #',
                    'value' => function($model)
                        {
                            return $model->request->id;
                        }
                ],
                [
                    'label' => 'Name',
                     'value'=> function($model)
                        {
                            return $model->request->employee->name;
                        }
                ],
                [
                    'label' => 'Username',
                    'visible' => (($model->request->requestService->name != RequestServiceMaster::VPN)) ? true : false,
                     'value'=> function($model)
                        {
                            return $model->request->employee->employeeInfos[0]->access_username;
                        }

                ],
                [
                    'label' => 'Request Type',
                     'value'=> function($model)
                        {
                            return $model->request->requestType->name;
                        }
                ],
                [
                    'label' => 'Request For',
                     'value'=> function($model)
                        {
                            return $model->request->requestService->name;
                        }
                ],
                [
                    'attribute'=> 'client_id',
                    'label' => 'Client',
                    'visible' =>(!empty($model->request->client)) ? true : false,
                    'value'=> function($model)
                        {
                            return $model->request->client->name;
                        }

                ],
                [
                    'attribute'=> 'instance_id',
                    'label' => 'Instance',
                    'visible' =>(!empty($model->request->instance)) ? true : false,
                    'value'=> function($model)
                        {
                            return $model->request->instance->name;
                        }

                ],
                [
                    'label' => 'Mysql Details',
                    'visible' =>(!empty($model->request->requestDetails)) ? true : false,
                    'value'=> function($model)
                     {
                              $items = $model->request->requestDetails;

                               foreach ($items as $item)
                               {
                                    $column = $item->privilege->name == 'Update' ? '('.$item->column_name .')':'';
                                    $mysqlFields[] = $item->privilege->name .' => '. $item->table->name . $column ;
                               }

                               return  "<pre>".implode(",\n",$mysqlFields)."</pre>";
                      },

                    'format' => 'html',
                ],
                [
                    'attribute' => 'posting_time',
                    'label' => 'Posting Time',
                    'value'=> function($model)
                    {
                        $value = strtotime($model->request->posting_time);
//                        $current_year = date("Y");
//                        $model = $current_year == date('Y',$value) ? date(' d M, g:i a',$value) : date('M d,Y g:i a',$value);
                        $dateTime = date('d/m/Y H:i:s', $value);
                        return $dateTime;
                    }

                ],
                [
                    'attribute' => 'number_of_days',
                    'label' => 'Access Needed Until',
                    'value'=> function($model)
                    {
                        if(!empty($model->request->number_of_days))
                        {
   //                        $current_year = date("Y");
                           $value = strtotime($model->request->posting_time);
                           $date = date('d-m-Y', $value);
                           $date = date_create($date);
                           $days = $model->request->number_of_days -1;
                           $enddate = date_add($date, date_interval_create_from_date_string(" $days days"));
                           $date = date_format($enddate,"d/m/Y ");
                           return $date;
                        }
                        else
                        {
                            return 'Forever';
                        }
                     }
                ],
                [
                    'attribute'=> 'status_id',
                    'label' => 'Status',
                    'value'=> function($model)
                        {
                      return $model->request->status->name;
                    }
                ],
                [
                    'attribute'=> 'user_id',
                    'label' => $Statusheader,
                    'visible' => $model->status->name != RequestMaster::NEW_STATUS ? true : false,
                    'value'=> function($model)
                    {
                      return $model->user->name;
                    }
                ],
                [
                    'label' => 'Reason For Request',
                    'value'=> function($model)
                        {
                             return   $model->request->message;
                        }
                ],
                [
                    'label' => $messageHeader,
                    'attribute' => 'message',
                    'visible' => ($model->status->name == RequestMaster::DECLINED_STATUS || $model->status->name == RequestMaster::APPLIED_STATUS) ? true : false,
                    'value'=> function($model)
                        {
                             return   $model->message;
                        }
                ],


            ],
        'template' => '<tr><th style="width:20%;">{label}</th><td style="width:80%;">{value}</td></tr>',
    ]) ?>

</div>
